LOG=log
LOC1=/dfs/scratch1/dataset.rocky/spinn3r/F5
LOC2=/dfs/scratch0/dataset/spinn3r/F5
LOC3=/dfs/scratch0/dataset/spinn3r/D
LOC4=/dfs/scratch0/dataset/spinn3r/E

function get_long_name(){
	if [ $1 == "web" ]
	then
		CONTENT_LONG="web"
	elif [ $1 == "fb" ]
	then
		CONTENT_LONG="facebook"
	elif [ $1 == "tw" ]
	then
		CONTENT_LONG="twitter"
	fi
}

# check for arguments
if [ $# -lt 1 ]
then
        echo "ERROR: No enough arguments supplied!"
	echo "First argument should be one of web, tw, fb!"
        exit 1
fi
if [ $1 != "web" ] && [ $1 != "tw" ] && [ $1 != "fb" ]
then
        echo "ERROR: First argument should be one of web, tw, fb!"
        exit 1
fi
# end check

CONTENT=$1
if [ $1 == "web" ]
then
	CONTENT_LONG="web"
elif [ $1 == "fb" ]
then
	CONTENT_LONG="facebook"
elif [ $1 == "tw" ]
then
	CONTENT_LONG="twitter"
fi

if [ -d $LOG/$CONTENT ];
then
	for YEAR_MONTH in `ls $LOG/$CONTENT` ;
	do
		OK=`grep -o __SUCCESS__ $LOG/$CONTENT/$YEAR_MONTH/* | wc -l`
		NOK=`grep -o __ERROR__ $LOG/$CONTENT/$YEAR_MONTH/* | wc -l`

		# get total number of files
		# number on locarion2 overwrites number on location1	
		# number on locarion3 overwrites number on location2
		# number on locarion4 overwrites number on location3
		ALL=-1
		if [ -d "$LOC1/$CONTENT_LONG/$YEAR_MONTH" ];
		then
			ALL=`ls $LOC1/$CONTENT_LONG/$YEAR_MONTH | wc -l`
		fi
		if [ -d "$LOC2/$CONTENT_LONG/$YEAR_MONTH" ];
        	then
                	ALL=`ls $LOC2/$CONTENT_LONG/$YEAR_MONTH | wc -l`
        	fi
		if [ -d "$LOC3/$CONTENT_LONG/$YEAR_MONTH" ];
        	then
                	ALL=`ls $LOC3/$CONTENT_LONG/$YEAR_MONTH | wc -l`
        	fi
		if [ -d "$LOC4/$CONTENT_LONG/$YEAR_MONTH" ];
        	then
                	ALL=`ls $LOC4/$CONTENT_LONG/$YEAR_MONTH | wc -l`
        	fi
	
		# verify that all were successfully copied
		if [ $OK -eq $ALL ] && [ $NOK -eq 0 ];
		then
			echo -e "$CONTENT-$YEAR_MONTH\t\t * OK *"
		else
			echo -e "$CONTENT-$YEAR_MONTH\t\t * ERROR * \t__SUCCESS__=$OK \t___ERROR__=$NOK \t__all files__=$ALL"
		fi
	done
fi
