/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.snap.spinn3rhadoop;

import java.util.ArrayList;
import java.util.List;

public class Spinn3rDoc {
    public String docId = null;
    public String url = null;
    public String date = null;
    public String title = null;
    public String title_raw = null;
    public String content = null;
    public String content_raw = null;
    public List<Link> links = new ArrayList<Link>();
    public List<Quote> quotes = new ArrayList<Quote>();
    public List<Lang> langs = new ArrayList<Lang>();
    public Spinn3rVersion version = null;
    public boolean isGarbled;
    public double nonGarbageFraction;

    private static String escapeNewLines(String in) {
        return in.replaceAll("\n", " &#10; ");
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        if (this.docId == null) {
            throw new IllegalArgumentException("Document has no docId");
        }
        str.append("I\t").append(this.docId).append("\n");
        if (this.version == null) {
            throw new IllegalArgumentException("Document has no version");
        }
        str.append("V\t").append((Object)this.version).append("\n");
        for (Lang lang : this.langs) {
            str.append("S\t").append(lang.toString()).append("\n");
        }
        str.append("G\t").append(String.valueOf(this.isGarbled) + "\t").append(String.valueOf(this.nonGarbageFraction) + "\t").append("\n");
        if (this.url == null) {
            throw new IllegalArgumentException("Document has no URL");
        }
        str.append("U\t").append(Spinn3rDoc.escapeNewLines(this.url)).append("\n");
        if (this.date == null) {
            throw new IllegalArgumentException("Document has no date");
        }
        str.append("D\t").append(Spinn3rDoc.escapeNewLines(this.date)).append("\n");
        if (this.title != null) {
            str.append("T\t").append(Spinn3rDoc.escapeNewLines(this.title)).append("\n");
        }
        if (this.title_raw != null) {
            str.append("F\t").append(Spinn3rDoc.escapeNewLines(this.title_raw)).append("\n");
        }
        if (this.content != null) {
            str.append("C\t").append(Spinn3rDoc.escapeNewLines(this.content)).append("\n");
        }
        if (this.content_raw != null) {
            str.append("H\t").append(Spinn3rDoc.escapeNewLines(this.content_raw)).append("\n");
        }
        for (Link link : this.links) {
            str.append("L\t").append(link.toString()).append("\n");
        }
        for (Quote quote : this.quotes) {
            str.append("Q\t").append(quote.toString()).append("\n");
        }
        return str.toString();
    }

    public void appendLang(String lang, double prob) {
        this.langs.add(new Lang(lang, prob));
    }

    public static enum ContentType {
        WEB,
        TWITTER,
        FACEBOOK;


        public String toString() {
            switch (this) {
                case WEB: {
                    return "W";
                }
                case TWITTER: {
                    return "T";
                }
                case FACEBOOK: {
                    return "F";
                }
            }
            throw new IllegalArgumentException();
        }
    }

    public class Lang {
        public String lang;
        public double prob;

        public Lang(String lang, double prob) {
            this.lang = lang;
            this.prob = prob;
        }

        public String toString() {
            return String.format("%s\t%f", this.lang, this.prob);
        }
    }

    public static class Link {
        public int startPos;
        public Integer length;
        public String url;

        public Link(int startPos, String url) {
            this.startPos = startPos;
            this.length = null;
            this.url = url;
        }

        public Link(int startPos, int length, String url) {
            this.startPos = startPos;
            this.length = length;
            this.url = url;
        }

        public String toString() {
            return String.format("%d\t%s\t%s", this.startPos, this.length == null ? "" : this.length, Spinn3rDoc.escapeNewLines(this.url));
        }
    }

    public static class Quote {
        public int startPos;
        public int length;
        public String text;

        public Quote(int startPos, int length, String text) {
            this.startPos = startPos;
            this.length = length;
            this.text = text;
        }

        public String toString() {
            return String.format("%s\t%d\t%s", this.startPos, this.length, Spinn3rDoc.escapeNewLines(this.text));
        }
    }

    public static enum Spinn3rVersion {
        A,
        B,
        C,
        D,
        E;

    }
}

