/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal.inst;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceRequestDeniedException;
import jdk.management.resource.internal.ApproverGroup;
import jdk.management.resource.internal.CompletionHandlerWrapper;
import jdk.management.resource.internal.FutureWrapper;
import jdk.management.resource.internal.ResourceIdImpl;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;
import sun.nio.ch.ThreadPool;

@InstrumentationTarget(value="sun.nio.ch.WindowsAsynchronousFileChannelImpl")
public final class WindowsAsynchronousFileChannelImplRMHooks {
    protected final FileDescriptor fdObj = null;
    protected final ReadWriteLock closeLock = new ReentrantReadWriteLock();
    protected volatile boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public static AsynchronousFileChannel open(FileDescriptor fileDescriptor, boolean bl, boolean bl2, ThreadPool threadPool) {
        long l;
        AsynchronousFileChannel asynchronousFileChannel = WindowsAsynchronousFileChannelImplRMHooks.open(fileDescriptor, bl, bl2, threadPool);
        JavaIOFileDescriptorAccess javaIOFileDescriptorAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
        try {
            l = javaIOFileDescriptorAccess.getHandle(fileDescriptor);
            if (l == -1L) {
                l = javaIOFileDescriptorAccess.get(fileDescriptor);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            l = javaIOFileDescriptorAccess.get(fileDescriptor);
        }
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(l);
        ResourceRequest resourceRequest = ApproverGroup.FILEDESCRIPTOR_OPEN_GROUP.getApprover(fileDescriptor);
        long l2 = 0L;
        boolean bl3 = false;
        try {
            l2 = resourceRequest.request(1L, resourceIdImpl);
            if (l2 < 1L) {
                throw new ResourceRequestDeniedException("Resource limited: too many open file descriptors");
            }
            bl3 = true;
        }
        finally {
            if (!bl3) {
                resourceRequest.request(-1L, resourceIdImpl);
                try {
                    asynchronousFileChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
        bl3 = false;
        resourceRequest = ApproverGroup.FILE_OPEN_GROUP.getApprover(asynchronousFileChannel);
        try {
            l2 = resourceRequest.request(1L, resourceIdImpl);
            if (l2 < 1L) {
                try {
                    asynchronousFileChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new ResourceRequestDeniedException("Resource limited: too many open files");
            }
            bl3 = true;
        }
        finally {
            if (!bl3) {
                resourceRequest.request(-1L, resourceIdImpl);
                try {
                    asynchronousFileChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
        return asynchronousFileChannel;
    }

    @InstrumentationMethod
    <A> Future<Integer> implRead(ByteBuffer byteBuffer, long l, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.fdObj);
        ResourceRequest resourceRequest = ApproverGroup.FILE_READ_GROUP.getApprover(this);
        long l2 = 0L;
        int n = byteBuffer.remaining();
        try {
            l2 = Math.max(resourceRequest.request(n, resourceIdImpl), 0L);
            if (l2 < (long)n) {
                throw new ResourceRequestDeniedException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            if (completionHandler != null) {
                completionHandler.failed(resourceRequestDeniedException, a);
                return null;
            }
            CompletableFuture<Integer> completableFuture = new CompletableFuture<Integer>();
            completableFuture.completeExceptionally(resourceRequestDeniedException);
            return completableFuture;
        }
        CompletionHandlerWrapper<Integer, ? super A> completionHandlerWrapper = null;
        if (completionHandler != null) {
            completionHandlerWrapper = new CompletionHandlerWrapper<Integer, A>(completionHandler, resourceIdImpl, resourceRequest, l2);
        }
        Future<Integer> future = this.implRead(byteBuffer, l, a, completionHandlerWrapper);
        if (completionHandler == null) {
            if (future.isDone()) {
                int n2 = 0;
                try {
                    n2 = future.get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
                n2 = Math.max(0, n2);
                resourceRequest.request(-(l2 - (long)n2), resourceIdImpl);
            } else {
                future = new FutureWrapper<Integer>(future, resourceIdImpl, resourceRequest, l2);
            }
        }
        return future;
    }

    @InstrumentationMethod
    <A> Future<Integer> implWrite(ByteBuffer byteBuffer, long l, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.fdObj);
        ResourceRequest resourceRequest = ApproverGroup.FILE_WRITE_GROUP.getApprover(this);
        long l2 = 0L;
        int n = byteBuffer.remaining();
        try {
            l2 = Math.max(resourceRequest.request(n, resourceIdImpl), 0L);
            if (l2 < (long)n) {
                throw new ResourceRequestDeniedException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            if (completionHandler != null) {
                completionHandler.failed(resourceRequestDeniedException, a);
                return null;
            }
            CompletableFuture<Integer> completableFuture = new CompletableFuture<Integer>();
            completableFuture.completeExceptionally(resourceRequestDeniedException);
            return completableFuture;
        }
        CompletionHandlerWrapper<Integer, ? super A> completionHandlerWrapper = null;
        if (completionHandler != null) {
            completionHandlerWrapper = new CompletionHandlerWrapper<Integer, A>(completionHandler, resourceIdImpl, resourceRequest, l2);
        }
        Future<Integer> future = this.implWrite(byteBuffer, l, a, completionHandlerWrapper);
        if (completionHandler == null) {
            if (future.isDone()) {
                int n2 = 0;
                try {
                    n2 = future.get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
                n2 = Math.max(0, n2);
                resourceRequest.request(-(l2 - (long)n2), resourceIdImpl);
            } else {
                future = new FutureWrapper<Integer>(future, resourceIdImpl, resourceRequest, l2);
            }
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public void close() throws IOException {
        this.closeLock.writeLock().lock();
        try {
            if (this.closed) {
                return;
            }
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
        try {
            this.close();
        }
        finally {
            JavaIOFileDescriptorAccess javaIOFileDescriptorAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
            long l = javaIOFileDescriptorAccess.getHandle(this.fdObj);
            if (l == -1L) {
                l = javaIOFileDescriptorAccess.get(this.fdObj);
            }
            ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(l);
            ResourceRequest resourceRequest = ApproverGroup.FILEDESCRIPTOR_OPEN_GROUP.getApprover(this.fdObj);
            resourceRequest.request(-1L, resourceIdImpl);
            resourceRequest = ApproverGroup.FILE_OPEN_GROUP.getApprover(this);
            resourceRequest.request(-1L, resourceIdImpl);
        }
    }
}

